/* movie.c
 * converter for BLINKENmini movies
 *  - converts movies between different file formats
 * Copyright (C) 2002 sphaera & 1stein (http://blinkenmini.1stein.no-ip.com/)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdio.h>
#include <malloc.h>

#include "movie.h"

//create a new frame
struct tFrame * FrameNew( unsigned int SizeX, unsigned int SizeY )
{
	struct tFrame * pFrame;

	//create the frame
	pFrame = (struct tFrame *)malloc( sizeof( struct tFrame ) );
	if( pFrame == NULL )
		return NULL;

	//put size into frame
	pFrame->SizeX = SizeX;
	pFrame->SizeY = SizeY;
	//set duration to default ( 0 )
	pFrame->Duration = 0;
	//no next frame
	pFrame->pNextFrame = NULL;

	//create ram for pixels
	pFrame->pPixel = (unsigned char *)malloc( sizeof( unsigned char ) * SizeX * SizeY );
	if( pFrame->pPixel == NULL )
	{
		free( pFrame );
		return NULL;
	}

	//return pointer to new frame
	return pFrame;
}

//free a frame
void FrameFree( struct tFrame * pFrame )
{
	//invalid pointer
	if( pFrame == NULL )
		return;

	//free frame and pixel ram
	free( pFrame->pPixel );
	free( pFrame );
}

//create a new movie
struct tMovie * MovieNew( )
{
	struct tMovie * pMovie;

	//create the movie
	pMovie = (struct tMovie *)malloc( sizeof( struct tMovie ) );
	if( pMovie == NULL )
		return NULL;

	//initialize size of the movie
	pMovie->SizeX = 0;
	pMovie->SizeY = 0;
	//no first frame
	pMovie->pFirstFrame = NULL;
	
	//create ram for comments
	pMovie->pComment = (char *)malloc( sizeof( char ) * 1 );
	if( pMovie->pComment == NULL )
	{
		free( pMovie );
		return NULL;
	}
	pMovie->pComment[0] = 0;

	//return pointer to new movie
	return pMovie;
}

//free a movie
void MovieFree( struct tMovie * pMovie )
{
	struct tFrame * pFrame, * pFrameX;

	//invalid pointer
	if( pMovie == NULL )
		return;

	//free all frames
	pFrame = pMovie->pFirstFrame;
	while( pFrame != NULL )
	{
		//free current frame and remember pointer to next one
		pFrameX = pFrame;
		pFrame = pFrame->pNextFrame;
		FrameFree( pFrameX );
	}

	//free the movie head
	free( pMovie->pComment );
	free( pMovie );
}

//append a frame to a movie
void MovieAppendFrame( struct tMovie * pMovie, struct tFrame * pFrame )
{
	struct tFrame * pCurFrame;

	//invalid pointer
	if( pMovie == NULL || pFrame == NULL )
		return;

	//movie is empty
	if( pMovie->pFirstFrame == NULL )
	{
		//new frame is first frame
		pMovie->pFirstFrame = pFrame;
		return;
	}

	//movie is not empty

	//find last frame
	pCurFrame = pMovie->pFirstFrame;
	while( pCurFrame->pNextFrame != NULL )
		pCurFrame = pCurFrame->pNextFrame;
	//append new frame after current frame
	pCurFrame->pNextFrame = pFrame;
}
