/* toolfunc.c
 * converter for BLINKENmini movies
 *  - converts movies between different file formats
 * Copyright (C) 2002 sphaera & 1stein (http://blinkenmini.1stein.no-ip.com/)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>

#include "toolfunc.h"

//read a line and truncate if too long
//return-value: 0 ok, 1 line truncated
int ReadLine( FILE * pFile, char * pBuffer, unsigned int BufferSize )
{
	char DummyBuffer[1024], * pNewline;

	//read beginning of line
	pBuffer[0] = 0;
	fgets( pBuffer, BufferSize, pFile );

	//no character read
	if( pBuffer[0] == 0 )
		//file end reached, so we are done
		return 0; //ok
	//newline in buffer
	pNewline = strchr( pBuffer, '\n' );
	if( pNewline != NULL )
	{
		//replace newline with 0
		*pNewline = 0;
		//we have the entire line, so we are done
		return 0; //ok
	}

	//file end reached
	if( feof( pFile ) )
		//we have the entire file, so the entire line, so we are done
		return 0;

	//read rest of line and ignore it
	for( ; ; )
	{
		//read next part of line
		DummyBuffer[0] = 0;
		fgets( DummyBuffer, sizeof( DummyBuffer ), pFile );

		//newline in buffer or no character read
		if( strchr( DummyBuffer, '\n' ) != NULL || DummyBuffer[0] == 0 )
			//we have the entire line, so we are done
			return 1; //line truncated
	}
}
