/* blp.c
 * converter for BLINKENmini movies
 *  - converts movies between different file formats
 * Copyright (C) 2002 sphaera & 1stein (blinkenmini@schuermans.info, https://blinkenmini.schuermans.info/)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <malloc.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
       
#include "movie.h"
#include "blp.h"

//send frames using blinkenlights-protocol
//UdpSocket must be an nonblocking and connected UDP-socket
int BlpSend( struct tMovie * pMovie, int UdpSocket )
{
	struct tFrame * pFrame;
	unsigned int FrameNo, Len, I, C, X, Y, Val;
	unsigned char * pBuffer;

	//process all frames
	FrameNo = 0;
	for( pFrame = pMovie->pFirstFrame; pFrame != NULL; pFrame = pFrame->pNextFrame )
	{
		//print info message
		printf( "BlpSend: sending frame %d...\n", FrameNo );

		//allocate buffer for packet
		Len = 12 + pFrame->SizeX * pFrame->SizeY;
		pBuffer = (unsigned char *)malloc( Len );
		if( pBuffer == NULL )
		{
			printf( "BlpSend: could not allocate buffer for UDP-packet\n" );
			return -1;
		}

		//assemble packet
		pBuffer[0] = 0xDE; //magic
		pBuffer[1] = 0xAD;
		pBuffer[2] = 0xBE;
		pBuffer[3] = 0xEF;
		*(unsigned long *)(pBuffer + 4) = htonl( FrameNo ); //frame-number
		*(unsigned short *)(pBuffer + 8) = htons( pFrame->SizeX ); //width
		*(unsigned short *)(pBuffer + 10) = htons( pFrame->SizeY ); //height
		I = 12; //pixels
		for( Y = 0; Y < pFrame->SizeY; Y++ )
		for( X = 0; X < pFrame->SizeX; X++ )
		{
			//calculate average value of all channels
			Val = 0;
			for( C = 0; C < pFrame->SizeC; C++ )
				Val += pFrame->pPixel[(Y * pFrame->SizeX + X) * pFrame->SizeC + C];
			if( pFrame->SizeC > 0 )
				Val /= pFrame->SizeC;
			//put pixel into buffer
			if( Val >= 0x80 )
				pBuffer[I] = 1;
			else
				pBuffer[I] = 0;
			I++;
		}

		//send frame
		send( UdpSocket, pBuffer, Len, 0 );
		//free buffer
		free( pBuffer );

		//wait for the requested time
		usleep( pFrame->Duration * 1000 );

		//count frames
		FrameNo++;
	} //for( pFrame ...

	//print info message
	printf( "BlpSend: %d frames successfully sent\n", FrameNo );

	return 0;
}

