/* glow.c
 * converter for BLINKENmini movies
 *  - converts movies between different file formats
 * Copyright (C) 2002 sphaera & 1stein (blinkenmini@schuermans.info, https://blinkenmini.schuermans.info/)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>
#include <malloc.h>

#include "toolfunc.h"
#include "movie.h"
#include "bmm.h"

//add glow to a movie
struct tMovie * GlowAdd( struct tMovie * pInMovie, unsigned int FrameMS, unsigned char PreGlowStep, unsigned char AfterGlowStep )
{
	int SizeC, SizeX, SizeY, MS, InFrameNo, OutFrameNo, InMS, OutMS;
	int Y, X, C, I, Off, Change;
	struct tFrame * pTmpFrame, * pFrame, * pInFrame, * pLastOutFrame;
	struct tMovie * pOutMovie;

	//print info message
	printf( "GlowAdd: processing...\n" );
	
	//get size
	SizeC = pInMovie->SizeC;
	SizeX = pInMovie->SizeX;
	SizeY = pInMovie->SizeY;

	//create temporary frame
	pTmpFrame = FrameNew( SizeC, SizeX, SizeY );
	if( pTmpFrame == NULL )
	{
		printf( "GlowAdd: could not create temporary frame\n" );
		return NULL;
	}
	//set pixels to off
	memset( pTmpFrame->pPixel, 0, sizeof( unsigned char ) * SizeC * SizeX * SizeY );

	//create output movie
	pOutMovie = MovieNew( );
	if( pOutMovie == NULL )
	{
		printf( "GlowAdd: could not create a movie\n" );
		FrameFree( pTmpFrame );
		return NULL;
	}

	//put size into movie
	pOutMovie->SizeC = SizeC;
	pOutMovie->SizeX = SizeX;
	pOutMovie->SizeY = SizeY;
	
	//add glow
	pInFrame = pInMovie->pFirstFrame;
	InFrameNo = 0;
	InMS = 0;
	OutFrameNo = 0;
	OutMS = 0;
	Change = 1;
	pLastOutFrame = NULL;
	for( MS = 0; ; MS += FrameMS )
	{
		//add frame to movie
		if( Change )
		{
			//create frame
			pFrame = FrameNew( SizeC, SizeX, SizeY );
			if( pFrame == NULL )
			{
				printf( "GlowAdd: could not create frame for time %d ms\n", MS );
				FrameFree( pTmpFrame );
				MovieFree( pOutMovie );
				return NULL;
			}
			//copy pixels from temporary frame
			memcpy( pFrame->pPixel, pTmpFrame->pPixel, sizeof( unsigned char ) * SizeC * SizeX * SizeY );
			//initial duration (important for last frame)
			pFrame->Duration = FrameMS;
			//appen frame to movie
			MovieAppendFrame( pOutMovie, pFrame );
			//count frames
			OutFrameNo++;
			//set duration of last frame
			if( pLastOutFrame != NULL )
				pLastOutFrame->Duration = MS - OutMS;
			//remember time of last frame and pointer to last frame
			OutMS = MS;
			pLastOutFrame = pFrame;
		}

		//end of input movie
		if( pInFrame == NULL )
		{
			//check if all pixels off
			Off = 1;
			for( Y = 0, I = 0; Y < SizeY; Y++ )
			for( X = 0; X < SizeX; X++ )
			for( C = 0; C < SizeC; C++, I++ )
				if( pTmpFrame->pPixel[I] != 0 )
					Off = 0;
			if( Off )
				break;
		}

		//next frame of the input movie
		if( pInFrame != NULL && InMS + max( pInFrame->Duration, FrameMS ) < MS )
		{
			InFrameNo++;
			InMS += max( pInFrame->Duration, FrameMS );
			pInFrame = pInFrame->pNextFrame;
		}
		
		//simulate glow
		Change = 0;
		if( pInFrame != NULL )
		{
			//input frame is wanted value
			for( Y = 0, I = 0; Y < SizeY; Y++ )
			for( X = 0; X < SizeX; X++ )
			for( C = 0; C < SizeC; C++, I++ )
			{
				if( (unsigned short)pInFrame->pPixel[I] > (unsigned short)pTmpFrame->pPixel[I] + PreGlowStep )
				{
					pTmpFrame->pPixel[I] += PreGlowStep;
					Change = 1;
				}
				else if( (unsigned short)pInFrame->pPixel[I] > (unsigned short)pTmpFrame->pPixel[I] )
				{
					pTmpFrame->pPixel[I] = pInFrame->pPixel[I];
					Change = 1;
				}
				if( (unsigned short)pInFrame->pPixel[I] + AfterGlowStep < (unsigned short)pTmpFrame->pPixel[I] )
				{
					pTmpFrame->pPixel[I] -= AfterGlowStep;
					Change = 1;
				}
				else if( (unsigned short)pInFrame->pPixel[I] < (unsigned short)pTmpFrame->pPixel[I] )
				{
					pTmpFrame->pPixel[I] = pInFrame->pPixel[I];
					Change = 1;
				}
			}
		}
		else
		{
			//wanted value is off
			for( Y = 0, I = 0; Y < SizeY; Y++ )
			for( X = 0; X < SizeX; X++ )
			for( C = 0; C < SizeC; C++, I++ )
			{
				if( pTmpFrame->pPixel[I] > AfterGlowStep )
				{
					pTmpFrame->pPixel[I] -= AfterGlowStep;
					Change = 1;
				}
				else
				{
					pTmpFrame->pPixel[I] = 0;
					Change = 1;
				}
			}
		}
	} //for( MS ...

	//free temporary frame
	FrameFree( pTmpFrame );

	//print info message
	printf( "GlowAdd: done\n" );

       //return output movie
       return pOutMovie;
}
