/* movie.h
 * converter for BLINKENmini movies
 *  - converts movies between different file formats
 * Copyright (C) 2002 sphaera & 1stein (blinkenmini@schuermans.info, https://blinkenmini.schuermans.info/)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef INC_movie
#define INC_movie

//structure for a frame
typedef struct tFrame
{
	unsigned int SizeC, SizeX, SizeY; //size of this frame (channels, width, height)
	unsigned char * pPixel; //pointer to malloc-ed ram with pixels
	unsigned int Duration; //delay of the frame in milliseconds
	struct tFrame * pNextFrame; //pointer to the next frame of the movie
} stFrame;

//head structure for a movie
typedef struct tMovie
{
	unsigned int SizeC, SizeX, SizeY; //maximum framesize of the entire movie
	char * pComment; //pointer to malloc-ed ram with comment string
	struct tFrame * pFirstFrame; //pointer to the first frame of the movie
} stMovie;

//create a new frame
struct tFrame * FrameNew( unsigned int SizeC, unsigned int SizeX, unsigned int SizeY );

//free a frame
void FrameFree( struct tFrame * pFrame );

//create a new movie
struct tMovie * MovieNew( );

//free a movie
void MovieFree( struct tMovie * pMovie );

//append a frame to a movie
void MovieAppendFrame( struct tMovie * pMovie, struct tFrame * pFrame );

#endif

