/* net.c
 * converter for BLINKENmini movies
 *  - converts movies between different file formats
 * Copyright (C) 2002 sphaera & 1stein (blinkenmini@schuermans.info, https://blinkenmini.schuermans.info/)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <malloc.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
       
#include "movie.h"
#include "net.h"

//send frames using the function ProtoSend
//AddrStr must be in format [[<bind-ip>:]<bind-port>,]<dest-ip>[:<dest-port>] (dest-port defaults to 2323)
int Send( struct tMovie * pMovie, char * AddrStr, int (* ProtoSend)( struct tMovie *, int ) )
{
	unsigned long BindIp, DestIp;
	unsigned short BindPort, DestPort;
	struct hostent * pHostent;
	char * pChr, * pBindTxt, * pDestTxt;
	char * pBindIp, * pBindPort, * pDestIp, * pDestPort;
	int UdpSocket, One, ErrorVal;
	struct sockaddr_in Addr;

	//divide AddrStr into BindTxt and DestTxt
	pChr = strchr( AddrStr, ',' );
	if( pChr == NULL )
	{
		pBindTxt = "0"; //bind to any port by default
		pDestTxt = AddrStr;
	}
	else
	{
		*pChr = 0;
		pBindTxt = AddrStr;
		pDestTxt = pChr + 1;
	}

	//divide BindTxt into IP and port
	pChr = strchr( pBindTxt, ':' );
	if( pChr == NULL )
	{
		pBindIp = "0.0.0.0"; //bind to any ip by default
		pBindPort = pBindTxt;
	}
	else
	{
		*pChr = 0;
		pBindIp = pBindTxt;
		pBindPort = pChr + 1;
	}

	//divide DestTxt into IP and port
	pChr = strchr( pDestTxt, ':' );
	if( pChr == NULL )
	{
		pDestIp = pDestTxt;
		pDestPort = "2323"; //send to port 2323 by default
	}
	else
	{
		*pChr = 0;
		pDestIp = pDestTxt;
		pDestPort = pChr + 1;
	}

	//get bind IP
	BindIp = inet_addr( pBindIp );
	if( BindIp == INADDR_NONE ) //resolve hostname
	{
		pHostent = gethostbyname( pBindIp );
		if( pHostent != NULL )
			if( pHostent->h_addr_list != NULL )
				if( pHostent->h_addr_list[0] != NULL )
					BindIp = *(unsigned long *)(pHostent->h_addr_list[0]);
	}	
	//get bind port
	BindPort = atoi( pBindPort );

	//get dest IP
	DestIp = inet_addr( pDestIp );
	if( DestIp == INADDR_NONE ) //resolve hostname
	{
		pHostent = gethostbyname( pDestIp );
		if( pHostent != NULL )
			if( pHostent->h_addr_list != NULL )
				if( pHostent->h_addr_list[0] != NULL )
					DestIp = *(unsigned long *)(pHostent->h_addr_list[0]);
	}	
	//get dest port
	DestPort = atoi( pDestPort );

	//print data
	printf( "Send: binding to %d.%d.%d.%d:%d\n",
		((unsigned char *)&BindIp)[0], ((unsigned char *)&BindIp)[1],
		((unsigned char *)&BindIp)[2], ((unsigned char *)&BindIp)[3],
		BindPort );
	printf( "Send: sending to %d.%d.%d.%d:%d\n",
		((unsigned char *)&DestIp)[0], ((unsigned char *)&DestIp)[1],
		((unsigned char *)&DestIp)[2], ((unsigned char *)&DestIp)[3],
		DestPort );

	//create UDP-socket
	UdpSocket = socket( AF_INET, SOCK_DGRAM, IPPROTO_UDP );
	if( UdpSocket == -1 )
	{
		printf( "Send: could not create UDP-socket\n\n" );
		return -1;
	}

	//unblock socket
	One = 1;
	if( ioctl( UdpSocket, FIONBIO, &One ) == -1 )
	{
		printf( "Send: could not unblock UDP-socket\n\n" );
		close( UdpSocket );
		return -1;
	}

	//bind socket
	Addr.sin_family = AF_INET;
	Addr.sin_port = htons( BindPort );
	Addr.sin_addr.s_addr = BindIp;
	if( bind( UdpSocket, (struct sockaddr *)&Addr, sizeof( struct sockaddr ) ) == -1 )
	{
		printf( "Send: could not bind UDP-socket\n\n" );
		close( UdpSocket );
		return -1;
	}

	//connect socket
	Addr.sin_family = AF_INET;
	Addr.sin_port = htons( DestPort );
	Addr.sin_addr.s_addr = DestIp;
	if( connect( UdpSocket, (struct sockaddr *)&Addr, sizeof( struct sockaddr ) ) == -1 )
	{
		printf( "Send: could not connect UDP-socket\n\n" );
		close( UdpSocket );
		return -1;
	}

	//call real send function
	ErrorVal = ProtoSend( pMovie, UdpSocket );

	//close socket
	close( UdpSocket );

	//return error value of ProtoSend
	return ErrorVal;
}

