/* kernel driver for BlinkenLeds (compatible to BLINKENmini)
 *  - character device kernel module for output to BlinkenLeds using the parallel port
 * version 1.1.92 date 2006-01-08
 * Copyright (C) 2002-2006 sphaera & 1stein (http://blinkenmini.schuermans.info/)
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <linux/ioctl.h>

//the major device number for the blinkenmini-device-inodes
#define BmDrvDevNoMajor 0xB0
//the minor device numbers for the blinkenmini-device-inodes
#define BmDrvOutDevNoMinor 0

//structures
typedef struct tBmDrvVersion //version-information
{
	char Name[32]; //name of the driver
	unsigned char Major; //major version
	unsigned char Minor; //minor version
	unsigned short Revision; //revision number
} stBmDrvVersion;
typedef struct tBmDrvPictureSize //size of BM-pictures
{
	unsigned char SizeX, SizeY; //size of the picture
} stBmDrvPictureSize;
typedef struct tBmDrvPicture //a BM-picture
{
	unsigned char SizeX, SizeY; //size of the picture
	unsigned char * pPixels; //pointer to the buffer with the pixels
	                         //(SizeY lines from top to bottom,
				 // each line with SizeX pixels from left to right)
} stBmDrvPicture;

//ioctls
#define BmDrvIoctlNoGetVersion     _IOR( BmDrvDevNoMajor, 0, struct tBmDrvVersion * ) //get version of bmdrv (BmDrvOut)
#define BmDrvIoctlNoGetPictureSize _IOR( BmDrvDevNoMajor, 1, struct tBmDrvPictureSize * ) //get picture size of bmdrv (BmDrvOut)
#define BmDrvIoctlNoSetPicture     _IOW( BmDrvDevNoMajor, 2, struct tBmDrvPicture * ) //set current picture (BmDrvOut)

//error codes
#define BmDrvErrIoctlNo     1 //an unknown ioctl-number was called
#define BmDrvErrPictureSize 2 //the picture size was not acceptable
#define BmDrvErrPixelBuffer 3 //the buffer with the pixels was not okay

