/* life.c
 * BLINKENmini games
 * Copyright (C) 2002 sphaera & 1stein (http://blinkenmini.1stein.no-ip.com/)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>

#include "keys.h"
#include "life.h"

#define LifeStoneColor 0xFF
#define LifeCursorColor1 0xBF
#define LifeCursorColor2 0x40
#define LifeEmptyColor 0x00

#define count( array ) (sizeof( (array) ) / sizeof( (array)[0] ))

//current picture
extern int PictureSizeX, PictureSizeY;
extern unsigned char * * ppPicture;

//global variables
int LifeTickCnt; //tick counter
int LifeCursor; //cursor counter
int LifeX, LifeY; //cursor position
unsigned char * * ppLifeField, * * ppLifeFieldTmp; //pointer to game field and temporary game filed
int LifeRunning; //if life is running automatically

//calculate next step
void LifeStep( )
{
	int X, X_1, X1, Y, Y_1, Y1, Cnt;

	//calculate next state for all stones
	for( Y = 0; Y < PictureSizeY; Y++ )
	{
		for( X = 0; X < PictureSizeX; X++ )
		{
			//get coordinates of neighbour fields
			X_1 = X - 1;
			if( X_1 < 0 )
				X_1 = PictureSizeX - 1;
			X1 = X + 1;
			if( X1 > PictureSizeX - 1 )
				X1 = 0;
			Y_1 = Y - 1;
			if( Y_1 < 0 )
				Y_1 = PictureSizeY - 1;
			Y1 = Y + 1;
			if( Y1 > PictureSizeY - 1 )
				Y1 = 0;
			//count stones in neighbour fields
			Cnt = 0;
			if( ppLifeField[Y_1][X_1] )
				Cnt++;
			if( ppLifeField[Y_1][X] )
				Cnt++;
			if( ppLifeField[Y_1][X1] )
				Cnt++;
			if( ppLifeField[Y][X_1] )
				Cnt++;
			if( ppLifeField[Y][X1] )
				Cnt++;
			if( ppLifeField[Y1][X_1] )
				Cnt++;
			if( ppLifeField[Y1][X] )
				Cnt++;
			if( ppLifeField[Y1][X1] )
				Cnt++;
			//stone in next step
			// - if 3 neighbours
			// - if already there and 2 neighbours
			ppLifeFieldTmp[Y][X] = (Cnt == 3 || (ppLifeField[Y][X] && Cnt == 2));
		}
	}
	//copy next step back to field
	for( Y = 0; Y < PictureSizeY; Y++ )
		for( X = 0; X < PictureSizeX; X++ )
			ppLifeField[Y][X] = ppLifeFieldTmp[Y][X];	
}

//output current picture
void LifeOutput( )
{
	int X, Y;

	//copy game field to picture
	for( Y = 0; Y < PictureSizeY; Y++ )
		for( X = 0; X < PictureSizeX; X++ )
			if( ppLifeField[Y][X] )
				ppPicture[Y][X] = LifeStoneColor;
			else
				ppPicture[Y][X] = LifeEmptyColor;

	//put cursor into picture
	if( !LifeRunning )
	{
		switch( LifeCursor )
		{
			case 0: ppPicture[LifeY][LifeX] = LifeCursorColor1; break;
			case 2: ppPicture[LifeY][LifeX] = LifeCursorColor2; break;
		}
	}
}

//init-procedure: called at game start
void LifeInit( )
{
	int Y, X;

	//set global variables
	LifeTickCnt = 0;
	LifeCursor = 0;
	LifeX = (PictureSizeX - 1) / 2;
	LifeY = (PictureSizeY - 1) / 2;
	LifeRunning = 0;

	//allocate game field
	ppLifeField = (unsigned char * *)malloc( PictureSizeY * sizeof( unsigned char * ) );
	for( Y = 0; Y < PictureSizeY; Y++ )
		ppLifeField[Y] = (unsigned char *)malloc( PictureSizeX );
	//allocate temporary game field
	ppLifeFieldTmp = (unsigned char * *)malloc( PictureSizeY * sizeof( unsigned char * ) );
	for( Y = 0; Y < PictureSizeY; Y++ )
		ppLifeFieldTmp[Y] = (unsigned char *)malloc( PictureSizeX );

	//print message
	printf( "bmgames: life: init\n" );

	//clear game field
	for( Y = 0; Y < PictureSizeY; Y++ )
		for( X = 0; X < PictureSizeX; X++ )
			ppLifeField[Y][X] = 0;

	//output picture
	LifeOutput( );
}

//exit-procedure: called on game end
void LifeExit( )
{
	int Y;

	//free game field
	for( Y = 0; Y < PictureSizeY; Y++ )
		free( ppLifeField[Y] );
	free( ppLifeField );
	//free temporary game field
	for( Y = 0; Y < PictureSizeY; Y++ )
		free( ppLifeFieldTmp[Y] );
	free( ppLifeFieldTmp );

	//print message
	printf( "bmgames: life: exit\n" );
}

//tick-procedure: called every 0.1 seconds
void LifeTick( )
{
	//only do something every 0.3 seconds
	LifeTickCnt++;
	if( LifeTickCnt < 3 )
		return;
	LifeTickCnt = 0;

	//advance cursor counter
	LifeCursor++;
	if( LifeCursor >= 4 )
		LifeCursor = 0;

	//game runnning
	if( LifeRunning )
		//calculate next step
		LifeStep( );

        //output new picture
	LifeOutput( );
}

//action-procedure: called when button is pressed or released	
void LifeAction( int Ctr, int Btn, int Press )
{
	//only process pressed buttons of controller 0
	if( !Press || Ctr != 0 )
		return;

	//different buttons
	switch( Btn )
	{
		//start: start / stop life
		case KeyStart:
			if( LifeRunning )
			{
				LifeRunning = 0;
				//print message
				printf( "bmgames: life: game stopped\n" );
				//output new picture
				LifeOutput( );
			}
			else
			{
				LifeRunning = 1;
				//print message
				printf( "bmgames: life: game started\n" );
				//output new picture
				LifeOutput( );
			}
			break;

		//select: next step
		case KeySelect:
			if( !LifeRunning )
			{
				LifeStep( );
				//print message
				printf( "bmgames: life: next step\n" );
				//output new picture
				LifeOutput( );
			}
			break;

		//left: move cursor left
		case KeyLeft:
			if( !LifeRunning )
			{
				LifeX--;
				if( LifeX < 0 )
					LifeX = PictureSizeX - 1;
				//output new picture
				LifeOutput( );
			}
			break;

		//right: move cursor right
		case KeyRight:
			if( !LifeRunning )
			{
				LifeX++;
				if( LifeX > PictureSizeX - 1 )
					LifeX = 0;
				//output new picture
				LifeOutput( );
			}
			break;

		//up: move cursor up
		case KeyUp:
			if( !LifeRunning )
			{
				LifeY--;
				if( LifeY < 0 )
					LifeY = PictureSizeY - 1;
				//output new picture
				LifeOutput( );
			}
			break;

		//down: move cursor down
		case KeyDown:
			if( !LifeRunning )
			{
				LifeY++;
				if( LifeY > PictureSizeY - 1 )
					LifeY = 0;
				//output new picture
				LifeOutput( );
			}
			break;

		//B: remove stone
		case KeyB:
			if( !LifeRunning )
			{
				ppLifeField[LifeY][LifeX] = 0;
				//output new picture
				LifeOutput( );
			}
			break;

		//Y: create stone
		case KeyY:
			if( !LifeRunning )
			{
				ppLifeField[LifeY][LifeX] = 1;
				//output new picture
				LifeOutput( );
			}
			break;
	}
}

