/* pong.c
 * BLINKENmini games
 * Copyright (C) 2002 sphaera & 1stein (http://blinkenmini.1stein.no-ip.com/)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>

#include "keys.h"
#include "pong.h"

#define PongPlayerLeft 0
#define PongPlayerRight 1
#define PongPlayerTop 2
#define PongPlayerBottom 3
#define PongPlayerCnt 4
char * PongPlayerName[PongPlayerCnt] = { "left", "right", "top", "bottom" };

#define PongBallColor 0xFF
#define PongBallBlinkColor 0x5F
#define PongPlayerColor 0xFF
#define PongWallColor 0xBF
#define PongEmptyColor 0x00

#define count( array ) (sizeof( (array) ) / sizeof( (array)[0] ))

//current picture
extern int PictureSizeX, PictureSizeY;
extern unsigned char * * ppPicture;

//global variables
int PongTickCnt; //tick counter
int PongBallOut; //is set to something different from 0 if ball is out (and is decremented then)
int PongBallPosX, PongBallPosY; //position of ball
int PongBallDirX, PongBallDirY; //direction of ball
int PongPlayerActive[PongPlayerCnt]; //if players are active
int PongPlayerPos[PongPlayerCnt]; //position of player

//output current picture
void PongOutput( )
{
	int X, Y;

	//empty picture
	for( Y = 0; Y < PictureSizeY; Y++ )
		for( X = 0; X < PictureSizeX; X++ )
			ppPicture[Y][X] = PongEmptyColor;

	//put walls into corners
	ppPicture[0][0] = PongWallColor;
	ppPicture[0][PictureSizeX - 1] = PongWallColor;
	ppPicture[PictureSizeY - 1][0] = PongWallColor;
	ppPicture[PictureSizeY - 1][PictureSizeX - 1] = PongWallColor;

	//put players into picture
	if( PongPlayerActive[PongPlayerLeft] )
		//active left player
		for( Y = PongPlayerPos[PongPlayerLeft] - 1; Y <= PongPlayerPos[PongPlayerLeft]; Y++ )
			ppPicture[Y][0] = PongPlayerColor;
	else
		//inactive left player
		for( Y = 1; Y <= PictureSizeY - 2; Y++ )
			ppPicture[Y][0] = PongWallColor;
	if( PongPlayerActive[PongPlayerRight] )
		//active right player
		for( Y = PongPlayerPos[PongPlayerRight] - 1; Y <= PongPlayerPos[PongPlayerRight]; Y++ )
			ppPicture[Y][PictureSizeX - 1] = PongPlayerColor;
	else
		//inactive right player
		for( Y = 1; Y <= PictureSizeY - 2; Y++ )
			ppPicture[Y][PictureSizeX - 1] = PongWallColor;
	if( PongPlayerActive[PongPlayerTop] )
		//active top player
		for( X = PongPlayerPos[PongPlayerTop] - 2; X <= PongPlayerPos[PongPlayerTop] + 1; X++ )
			ppPicture[0][X] = PongPlayerColor;
	else
		//inactive top player
		for( X = 1; X <= PictureSizeX - 2; X++ )
			ppPicture[0][X] = PongWallColor;
	if( PongPlayerActive[PongPlayerBottom] )
		//active bottom player
		for( X = PongPlayerPos[PongPlayerBottom] - 2; X <= PongPlayerPos[PongPlayerBottom] + 1; X++ )
			ppPicture[PictureSizeY - 1][X] = PongPlayerColor;
	else
		//inactive bottom player
		for( X = 1; X <= PictureSizeX - 2; X++ )
			ppPicture[PictureSizeY - 1][X] = PongWallColor;

	//put ball into picture
	if( PongBallOut & 1 )
		ppPicture[PongBallPosY][PongBallPosX] = PongBallBlinkColor;
	else
		ppPicture[PongBallPosY][PongBallPosX] = PongBallColor;
}

//set ball to start position and set its direction
void PongNewBall( )
{
	//set ball position to center
	PongBallPosX = (PictureSizeX - 1) / 2 + rand( ) % 3 - 1;
	PongBallPosY = (PictureSizeY - 1) / 2 + rand( ) % 3 - 1;

	//set ball direction
	switch( rand( ) % 4 )
	{
		case 0: PongBallDirX = -1; PongBallDirY = -1; break;
		case 1: PongBallDirX =  1; PongBallDirY = -1; break;
		case 2: PongBallDirX = -1; PongBallDirY =  1; break;
		case 3: PongBallDirX =  1; PongBallDirY =  1; break;
	}

	//ball is not out
	PongBallOut = 0;

	//print message
	printf( "bmgames: pong: new ball\n" );
}

//init-procedure: called at game start
void PongInit( )
{
	int I;

	//default values for variables
	PongTickCnt = 0;

	//set players to inactive
	for( I = 0; I < PongPlayerCnt; I++ )
		PongPlayerActive[I] = 0;

	//print message
	printf( "bmgames: pong: init\n" );

	//new ball
	PongNewBall( );

	//output new picture
	PongOutput( );
}

//exit-procedure: called on game end
void PongExit( )
{
	//print message
	printf( "bmgames: pong: exit\n" );
}

//tick-procedure: called every 0.1 seconds
void PongTick( )
{
	int Bounced;

	//only do something every 0.5 seconds
	PongTickCnt++;
	if( PongTickCnt < 5 )
		return;
	PongTickCnt = 0;

	//ball bounces
	do
	{
		Bounced = 0;
		//ball bounces at inactive left player
		if( PongBallPosX == 1 && PongBallDirX == -1 && !PongPlayerActive[PongPlayerLeft] )
		{
			PongBallDirX = 1;
			Bounced = 1;
		}
		//ball bounces at inactive right player
		if( PongBallPosX == PictureSizeX - 2 && PongBallDirX == 1 && !PongPlayerActive[PongPlayerRight] )
		{
			PongBallDirX = -1;
			Bounced = 1;
		}
		//ball bounces at inactive top player
		if( PongBallPosY == 1 && PongBallDirY == -1 && !PongPlayerActive[PongPlayerTop] )
		{
			PongBallDirY = 1;
			Bounced = 1;
		}
		//ball bounces at inactive bottom player
		if( PongBallPosY == PictureSizeY - 2 && PongBallDirY == 1 && !PongPlayerActive[PongPlayerBottom] )
		{
			PongBallDirY = -1;
			Bounced = 1;
		}
		//ball bounces at active left player
		if( PongBallPosX == 1 && PongBallDirX == -1 && PongPlayerActive[PongPlayerLeft] )
		{
			//ball hits player
			if( PongBallPosY >= PongPlayerPos[PongPlayerLeft] - 1 && PongBallPosY <= PongPlayerPos[PongPlayerLeft] )
			{
				PongBallDirX = 1;
				Bounced = 1;
			}
			//ball hits upper corner of player
			if( PongBallPosY == PongPlayerPos[PongPlayerLeft] - 2 && PongBallDirY == 1 )
			{
				PongBallDirX = 1;
				PongBallDirY = -1;
				Bounced = 1;
			}
			//ball hits lower corner of player
			if( PongBallPosY == PongPlayerPos[PongPlayerLeft] + 1 && PongBallDirY == -1 )
			{
				PongBallDirX = 1;
				PongBallDirY = 1;
				Bounced = 1;
			}
		}
		//ball bounces at active right player
		if( PongBallPosX == PictureSizeX - 2 && PongBallDirX == 1 && PongPlayerActive[PongPlayerRight] )
		{
			//ball hits player
			if( PongBallPosY >= PongPlayerPos[PongPlayerRight] - 1 && PongBallPosY <= PongPlayerPos[PongPlayerRight] )
			{
				PongBallDirX = -1;
				Bounced = 1;
			}
			//ball hits upper corner of player
			if( PongBallPosY == PongPlayerPos[PongPlayerRight] - 2 && PongBallDirY == 1 )
			{
				PongBallDirX = -1;
				PongBallDirY = -1;
				Bounced = 1;
			}
			//ball hits lower corner of player
			if( PongBallPosY == PongPlayerPos[PongPlayerRight] + 1 && PongBallDirY == -1 )
			{
				PongBallDirX = -1;
				PongBallDirY = 1;
				Bounced = 1;
			}
		}
		//ball bounces at active top player
		if( PongBallPosY == 1 && PongBallDirY == -1 && PongPlayerActive[PongPlayerTop] )
		{
			//ball hits player
			if( PongBallPosX >= PongPlayerPos[PongPlayerTop] - 2 && PongBallPosX <= PongPlayerPos[PongPlayerTop] + 1 )
			{
				PongBallDirY = 1;
				Bounced = 1;
			}
			//ball hits left corner of player
			if( PongBallPosX == PongPlayerPos[PongPlayerTop] - 3 && PongBallDirX == 1 )
			{
				PongBallDirY = 1;
				PongBallDirX = -1;
				Bounced = 1;
			}
			//ball hits right corner of player
			if( PongBallPosX == PongPlayerPos[PongPlayerTop] + 2 && PongBallDirX == -1 )
			{
				PongBallDirY = 1;
				PongBallDirX = 1;
				Bounced = 1;
			}
		}
		//ball bounces at active bottom player
		if( PongBallPosY == PictureSizeY - 2 && PongBallDirY == 1 && PongPlayerActive[PongPlayerBottom] )
		{
			//ball hits player
			if( PongBallPosX >= PongPlayerPos[PongPlayerBottom] - 2 && PongBallPosX <= PongPlayerPos[PongPlayerBottom] + 1 )
			{
				PongBallDirY = -1;
				Bounced = 1;
			}
			//ball hits left corner of player
			if( PongBallPosX == PongPlayerPos[PongPlayerBottom] - 3 && PongBallDirX == 1 )
			{
				PongBallDirY = -1;
				PongBallDirX = -1;
				Bounced = 1;
			}
			//ball hits right corner of player
			if( PongBallPosX == PongPlayerPos[PongPlayerBottom] + 2 && PongBallDirX == -1 )
			{
				PongBallDirY = -1;
				PongBallDirX = 1;
				Bounced = 1;
			}
		}
		//ball bounces at top left corner
		if( PongBallPosX == 1 && PongBallPosY == 1 && PongBallDirX == -1 && PongBallDirY == -1 )
		{
			PongBallDirX = 1;
			PongBallDirY = 1;
			Bounced = 1;
		}
		//ball bounces at top right corner
		if( PongBallPosX == PictureSizeX - 2 && PongBallPosY == 1 && PongBallDirX == 1 && PongBallDirY == -1 )
		{
			PongBallDirX = -1;
			PongBallDirY = 1;
			Bounced = 1;
		}
		//ball bounces at bottom left corner
		if( PongBallPosX == 1 && PongBallPosY == PictureSizeY - 2 && PongBallDirX == -1 && PongBallDirY == 1 )
		{
			PongBallDirX = 1;
			PongBallDirY = -1;
			Bounced = 1;
		}
		//ball bounces at bottom right corner
		if( PongBallPosX == PictureSizeX - 2 && PongBallPosY == PictureSizeY - 2 && PongBallDirX == 1 && PongBallDirY == 1 )
		{
			PongBallDirX = -1;
			PongBallDirY = -1;
			Bounced = 1;
		}
	}
	while( Bounced );

	//ball is out
	if( PongBallOut )
	{
		//decrement ball out time
		PongBallOut--;
		//new ball?
		if( PongBallOut == 0 )
			PongNewBall( );
	}
	//ball is not out
	else
	{
		//move ball
		PongBallPosX += PongBallDirX;
		PongBallPosY += PongBallDirY;

		//ball is out at left
		if( PongBallPosX == 0 )
		{
			PongBallOut = 6;
			//print message
			printf( "bmgames: pong: %s player (%d) missed the ball\n", PongPlayerName[PongPlayerLeft], PongPlayerLeft );
		}
		//ball is out at right
		if( PongBallPosX == PictureSizeX - 1 )
		{
			PongBallOut = 6;
			//print message
			printf( "bmgames: pong: %s player (%d) missed the ball\n", PongPlayerName[PongPlayerRight], PongPlayerRight );
		}
		//ball is out at top
		if( PongBallPosY == 0 )
		{
			PongBallOut = 6;
			//print message
			printf( "bmgames: pong: %s player (%d) missed the ball\n", PongPlayerName[PongPlayerTop], PongPlayerTop );
		}
		//ball is out at bottom
		if( PongBallPosY == PictureSizeY - 1 )
		{
			PongBallOut = 6;
			//print message
			printf( "bmgames: pong: %s player (%d) missed the ball\n", PongPlayerName[PongPlayerTop], PongPlayerBottom );
		}
	}

        //output new picture
	PongOutput( );
}

//action-procedure: called when button is pressed or released	
void PongAction( int Ctr, int Btn, int Press )
{
	//only process pressed buttons of controllers 0..(PlayerCnt-1)
	if( !Press || Ctr >= PongPlayerCnt )
		return;

	//different buttons
	switch( Btn )
	{
		//select: join / leave game
		case KeySelect:
			//player is active
			if( PongPlayerActive[Ctr] )
			{
				//set player to inactive
				PongPlayerActive[Ctr] = 0;
				//print message
				printf( "bmgames: pong: %s player (no. %d) left the game\n", PongPlayerName[Ctr], Ctr );
			}
			//player is not active
			else
			{
				//set player to active
				PongPlayerActive[Ctr] = 1;
				//set player position
				switch( Ctr )
				{
					case PongPlayerLeft:   PongPlayerPos[Ctr] = PictureSizeY / 2; break;
					case PongPlayerRight:  PongPlayerPos[Ctr] = PictureSizeY / 2; break;
					case PongPlayerBottom: PongPlayerPos[Ctr] = PictureSizeX / 2; break;
					case PongPlayerTop:    PongPlayerPos[Ctr] = PictureSizeX / 2; break;
				}
				//print message
				printf( "bmgames: pong: %s player (no. %d) joined the game\n", PongPlayerName[Ctr], Ctr );
			}
			//output new picture
			PongOutput( );
			break;

		//left: move leftwards
		case KeyLeft:
			if( Ctr == PongPlayerTop || Ctr == PongPlayerBottom )
			{
				if( PongPlayerPos[Ctr] > 3 && PongPlayerActive[Ctr] && !PongBallOut )
				{
					PongPlayerPos[Ctr]--;
					//output new picture
					PongOutput( );
				}
			}
			break;

		//right: move rightwards
		case KeyRight:
			if( Ctr == PongPlayerTop || Ctr == PongPlayerBottom )
			{
				if( PongPlayerPos[Ctr] < PictureSizeX - 3 && PongPlayerActive[Ctr] && !PongBallOut )
				{
					PongPlayerPos[Ctr]++;
					//output new picture
					PongOutput( );
				}
			}
			break;

		//up: move upwards
		case KeyUp:
			if( Ctr == PongPlayerLeft || Ctr == PongPlayerRight )
			{
				if( PongPlayerPos[Ctr] > 2 && PongPlayerActive[Ctr] && !PongBallOut )
				{
					PongPlayerPos[Ctr]--;
					//output new picture
					PongOutput( );
				}
			}
			break;

		//down: move downwards
		case KeyDown:
			if( Ctr == PongPlayerLeft || Ctr == PongPlayerRight )
			{
				if( PongPlayerPos[Ctr] < PictureSizeY - 2 && PongPlayerActive[Ctr] && !PongBallOut )
				{
					PongPlayerPos[Ctr]++;
					//output new picture
					PongOutput( );
				}
			}
			break;
	}
}

